"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSloUiActions = registerSloUiActions;
var _public = require("@kbn/ui-actions-plugin/public");
var _constants = require("../embeddable/slo/alerts/constants");
var _constants2 = require("../embeddable/slo/error_budget/constants");
var _constants3 = require("../embeddable/slo/overview/constants");
var _constants4 = require("../embeddable/slo/burn_rate/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function registerSloUiActions(uiActions, coreStart, pluginsStart, sloClient) {
  const {
    serverless,
    cloud
  } = pluginsStart;

  // Assign triggers
  // Only register these actions in stateful kibana, and the serverless observability project
  if (Boolean(serverless && (cloud === null || cloud === void 0 ? void 0 : cloud.serverless.projectType) === 'observability' || !serverless)) {
    uiActions.addTriggerActionAsync(_public.ADD_PANEL_TRIGGER, _constants3.ADD_SLO_OVERVIEW_ACTION_ID, async () => {
      const {
        createOverviewPanelAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./add_panel_actions_module')));
      return createOverviewPanelAction(coreStart, pluginsStart, sloClient);
    });
    uiActions.addTriggerActionAsync(_public.ADD_PANEL_TRIGGER, _constants2.ADD_SLO_ERROR_BUDGET_ACTION_ID, async () => {
      const {
        createAddErrorBudgetPanelAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./add_panel_actions_module')));
      return createAddErrorBudgetPanelAction(coreStart, pluginsStart, sloClient);
    });
    uiActions.addTriggerActionAsync(_public.ADD_PANEL_TRIGGER, _constants.ADD_SLO_ALERTS_ACTION_ID, async () => {
      const {
        createAddAlertsPanelAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./add_panel_actions_module')));
      return createAddAlertsPanelAction(coreStart, pluginsStart, sloClient);
    });
    uiActions.addTriggerActionAsync(_public.ADD_PANEL_TRIGGER, _constants4.ADD_BURN_RATE_ACTION_ID, async () => {
      const {
        createBurnRatePanelAction
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./add_panel_actions_module')));
      return createBurnRatePanelAction(coreStart, pluginsStart, sloClient);
    });
  }
}