"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAddAlertsPanelAction = createAddAlertsPanelAction;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-shared-plugin/common");
var _presentationContainers = require("@kbn/presentation-containers");
var _public = require("@kbn/ui-actions-plugin/public");
var _constants = require("../embeddable/slo/alerts/constants");
var _slo_alerts_open_configuration = require("../embeddable/slo/alerts/slo_alerts_open_configuration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createAddAlertsPanelAction(coreStart, pluginsStart, sloClient) {
  return {
    id: _constants.ADD_SLO_ALERTS_ACTION_ID,
    grouping: _common.COMMON_OBSERVABILITY_GROUPING,
    getIconType: () => 'alert',
    order: 10,
    isCompatible: async ({
      embeddable
    }) => {
      return (0, _presentationContainers.apiIsPresentationContainer)(embeddable);
    },
    execute: async ({
      embeddable
    }) => {
      if (!(0, _presentationContainers.apiIsPresentationContainer)(embeddable)) throw new _public.IncompatibleActionError();
      try {
        const initialState = await (0, _slo_alerts_open_configuration.openSloConfiguration)(coreStart, pluginsStart, sloClient);
        embeddable.addNewPanel({
          panelType: _constants.SLO_ALERTS_EMBEDDABLE_ID,
          serializedState: {
            rawState: initialState
          }
        }, true);
      } catch (e) {
        return Promise.reject();
      }
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.slo.sloAlertsEmbeddable.displayName', {
      defaultMessage: 'SLO Alerts'
    })
  };
}