"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloListItem = SloListItem;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_slo_list_actions = require("../../hooks/use_slo_list_actions");
var _use_slo_summary = require("../../hooks/use_slo_summary");
var _slo_badges = require("../badges/slo_badges");
var _burn_rate_rule_flyout = require("../common/burn_rate_rule_flyout");
var _edit_burn_rate_rule_flyout = require("../common/edit_burn_rate_rule_flyout");
var _slo_groupings = require("../common/slo_groupings");
var _slo_item_actions = require("../slo_item_actions");
var _slo_summary = require("../slo_summary");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloListItem({
  slo,
  rules,
  refetchRules,
  historicalSummary = [],
  historicalSummaryLoading,
  activeAlerts
}) {
  const [isActionsPopoverOpen, setIsActionsPopoverOpen] = (0, _react.useState)(false);
  const [isAddRuleFlyoutOpen, setIsAddRuleFlyoutOpen] = (0, _react.useState)(false);
  const [isEditRuleFlyoutOpen, setIsEditRuleFlyoutOpen] = (0, _react.useState)(false);
  const {
    sloDetailsUrl
  } = (0, _use_slo_summary.useSloFormattedSummary)(slo);
  const {
    handleCreateRule
  } = (0, _use_slo_list_actions.useSloListActions)({
    slo,
    setIsActionsPopoverOpen,
    setIsAddRuleFlyoutOpen
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "sloItem",
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("a", {
    "data-test-subj": "o11ySloListItemLink",
    href: sloDetailsUrl
  }, slo.name), /*#__PURE__*/_react.default.createElement(_slo_groupings.SLOGroupings, {
    slo: slo
  })))), /*#__PURE__*/_react.default.createElement(_slo_badges.SloBadges, {
    activeAlerts: activeAlerts,
    isLoading: !slo.summary,
    rules: rules,
    slo: slo,
    onClickRuleBadge: handleCreateRule
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_slo_summary.SloSummary, {
    slo: slo,
    historicalSummary: historicalSummary,
    historicalSummaryLoading: historicalSummaryLoading
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_slo_item_actions.SloItemActions, {
    slo: slo,
    rules: rules,
    isActionsPopoverOpen: isActionsPopoverOpen,
    setIsAddRuleFlyoutOpen: setIsAddRuleFlyoutOpen,
    setIsEditRuleFlyoutOpen: setIsEditRuleFlyoutOpen,
    setIsActionsPopoverOpen: setIsActionsPopoverOpen
  }))), /*#__PURE__*/_react.default.createElement(_burn_rate_rule_flyout.BurnRateRuleFlyout, {
    slo: slo,
    isAddRuleFlyoutOpen: isAddRuleFlyoutOpen,
    setIsAddRuleFlyoutOpen: setIsAddRuleFlyoutOpen
  }), /*#__PURE__*/_react.default.createElement(_edit_burn_rate_rule_flyout.EditBurnRateRuleFlyout, {
    rule: rules === null || rules === void 0 ? void 0 : rules[0],
    isEditRuleFlyoutOpen: isEditRuleFlyoutOpen,
    setIsEditRuleFlyoutOpen: setIsEditRuleFlyoutOpen,
    refetchRules: refetchRules
  }));
}