"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloEditFormDescriptionSection = SloEditFormDescriptionSection;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_fetch_suggestions = require("../hooks/use_fetch_suggestions");
var _optional_text = require("./common/optional_text");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloEditFormDescriptionSection() {
  const {
    control,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  const sloNameId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'sloName'
  });
  const descriptionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'sloDescription'
  });
  const tagsId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'tags'
  });
  const {
    suggestions
  } = (0, _use_fetch_suggestions.useFetchSLOSuggestions)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none",
    style: {
      maxWidth: _constants.MAX_WIDTH
    },
    "data-test-subj": "sloEditFormDescriptionSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: getFieldState('name').invalid,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.description.sloName', {
      defaultMessage: 'SLO Name'
    })
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "name",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, field, {
      fullWidth: true,
      isInvalid: fieldState.invalid,
      id: sloNameId,
      "data-test-subj": "sloFormNameInput",
      placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.description.sloNamePlaceholder', {
        defaultMessage: 'Name for the SLO'
      })
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.description.sloDescription', {
      defaultMessage: 'Description'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_optional_text.OptionalText, null)
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "description",
    defaultValue: "",
    control: control,
    rules: {
      required: false
    },
    render: ({
      field: {
        ref,
        ...field
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({}, field, {
      fullWidth: true,
      id: descriptionId,
      "data-test-subj": "sloFormDescriptionTextArea",
      placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.description.sloDescriptionPlaceholder', {
        defaultMessage: 'A short description of the SLO'
      })
    }))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.slo.sloEdit.tags.label', {
      defaultMessage: 'Tags'
    })
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "tags",
    control: control,
    defaultValue: [],
    rules: {
      required: false
    },
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => {
      var _suggestions$tags;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, field, {
        id: tagsId,
        fullWidth: true,
        "aria-label": _i18n.i18n.translate('xpack.slo.sloEdit.tags.placeholder', {
          defaultMessage: 'Add tags'
        }),
        placeholder: _i18n.i18n.translate('xpack.slo.sloEdit.tags.placeholder', {
          defaultMessage: 'Add tags'
        }),
        isInvalid: fieldState.invalid,
        options: (_suggestions$tags = suggestions === null || suggestions === void 0 ? void 0 : suggestions.tags) !== null && _suggestions$tags !== void 0 ? _suggestions$tags : [],
        selectedOptions: generateTagOptions(field.value),
        onChange: selected => {
          if (selected.length) {
            return field.onChange(selected.map(opts => opts.value));
          }
          field.onChange([]);
        },
        onCreateOption: (searchValue, options = []) => {
          var _field$value;
          const normalizedSearchValue = searchValue.trim().toLowerCase();
          if (!normalizedSearchValue) {
            return;
          }
          const values = (_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : [];
          if (values.findIndex(tag => tag.trim().toLowerCase() === normalizedSearchValue) === -1) {
            field.onChange([...values, searchValue]);
          }
        },
        isClearable: true,
        "data-test-subj": "sloEditTagsSelector"
      }));
    }
  })));
}
function generateTagOptions(tags = []) {
  return tags.map(tag => ({
    label: tag,
    value: tag,
    'data-test-subj': `${tag}Option`
  }));
}