"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloHealthCallout = SloHealthCallout;
var _eui = require("@elastic/eui");
var _constants = require("@kbn/deeplinks-management/constants");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _constants2 = require("../../../../common/constants");
var _action_modal = require("../../../context/action_modal");
var _use_fetch_slo_health = require("../../../hooks/use_fetch_slo_health");
var _use_kibana = require("../../../hooks/use_kibana");
var _content_with_inspect_cta = require("./health_callout/content_with_inspect_cta");
var _content_with_reset_cta = require("./health_callout/content_with_reset_cta");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloHealthCallout({
  slo
}) {
  const {
    isLoading,
    isError,
    data
  } = (0, _use_fetch_slo_health.useFetchSloHealth)({
    list: [slo]
  });
  const {
    share: {
      url: {
        locators
      }
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    triggerAction
  } = (0, _action_modal.useActionModal)();
  const handleReset = () => {
    triggerAction({
      type: 'reset',
      item: slo
    });
  };
  const managementLocator = locators.get(_constants.MANAGEMENT_APP_LOCATOR);
  const getUrl = transformId => {
    return (managementLocator === null || managementLocator === void 0 ? void 0 : managementLocator.getRedirectUrl({
      sectionId: 'data',
      appId: `transform?_a=${_rison.default.encode({
        transform: {
          queryText: transformId
        }
      })}`
    })) || '';
  };
  if (isLoading || isError || data === undefined || (data === null || data === void 0 ? void 0 : data.length) !== 1) {
    return null;
  }
  const health = data[0].health;
  if (health.overall === 'healthy') {
    return null;
  }
  const rollupTransformId = (0, _constants2.getSLOTransformId)(slo.id, slo.revision);
  const summaryTransformId = (0, _constants2.getSLOSummaryTransformId)(slo.id, slo.revision);
  const rollupUrl = getUrl(rollupTransformId);
  const summaryUrl = getUrl(summaryTransformId);
  const rollup = {
    unhealthy: health.rollup === 'unhealthy',
    missing: health.rollup === 'missing'
  };
  const summary = {
    unhealthy: health.summary === 'unhealthy',
    missing: health.summary === 'missing'
  };
  const rollupHasIssue = (0, _lodash.values)(rollup).some(Boolean);
  const summaryHasIssue = (0, _lodash.values)(summary).some(Boolean);
  const count = [rollupHasIssue, summaryHasIssue].filter(Boolean).length;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: _i18n.i18n.translate('xpack.slo.sloDetails.healthCallout.title', {
      defaultMessage: 'This SLO has issues with its transforms'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.sloDetails.healthCallout.description",
    defaultMessage: "The following {count, plural, one {transform needs} other {transforms need}} attention. You can inspect {count, plural, it {one} other {each one}} here:",
    values: {
      count
    }
  }), /*#__PURE__*/_react.default.createElement("ul", null, rollup.unhealthy && !!rollupUrl && /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_content_with_inspect_cta.ContentWithInspectCta, {
    textSize: "s",
    content: getUnhealthyText(rollupTransformId),
    url: rollupUrl
  })), rollup.missing && /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_content_with_reset_cta.ContentWithResetCta, {
    textSize: "s",
    content: getMissingText(rollupTransformId),
    handleReset: handleReset
  })), summary.unhealthy && !!summaryUrl && /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_content_with_inspect_cta.ContentWithInspectCta, {
    textSize: "s",
    content: getUnhealthyText(summaryTransformId),
    url: summaryUrl
  })), summary.missing && /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_content_with_reset_cta.ContentWithResetCta, {
    textSize: "s",
    content: getMissingText(summaryTransformId),
    handleReset: handleReset
  }))))));
}
const getUnhealthyText = transformId => _i18n.i18n.translate('xpack.slo.sloDetails.healthCallout.unhealthyTransformText', {
  defaultMessage: '{transformId} (unhealthy)',
  values: {
    transformId
  }
});
const getMissingText = transformId => _i18n.i18n.translate('xpack.slo.sloDetails.healthCallout.missingTransformText', {
  defaultMessage: '{transformId} (missing)',
  values: {
    transformId
  }
});