"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DisplayQuery = DisplayQuery;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-search-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_create_data_view = require("../../../../hooks/use_create_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilterItemI18n = (0, _i18nReact.injectI18n)(_public.FilterItem);
function DisplayQuery({
  query,
  index
}) {
  const {
    dataView
  } = (0, _use_create_data_view.useCreateDataView)({
    indexPatternString: index
  });
  const {
    docLinks,
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  if (typeof query === 'string' || !query) {
    return query ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      paddingSize: "s"
    }, query) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "*");
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, query.kqlQuery && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "kql",
    paddingSize: "s"
  }, query.kqlQuery), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })), dataView && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: true
  }, query.filters.map((filter, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: idx,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(FilterItemI18n, {
    id: 'filter-id' + idx,
    filter: filter,
    indexPatterns: [dataView],
    onUpdate: () => {},
    onRemove: () => {},
    docLinks: docLinks,
    uiSettings: uiSettings,
    readOnly: true
  })))));
}