"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteSlo = useDeleteSlo;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("./use_kibana");
var _query_key_factory = require("./query_key_factory");
var _use_plugin_context = require("./use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDeleteSlo() {
  const {
    notifications: {
      toasts
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    sloClient
  } = (0, _use_plugin_context.usePluginContext)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)(['deleteSlo'], ({
    id
  }) => {
    try {
      return sloClient.fetch(`DELETE /api/observability/slos/{id} 2023-10-31`, {
        params: {
          path: {
            id
          }
        }
      });
    } catch (error) {
      return Promise.reject(`Something went wrong: ${String(error)}`);
    }
  }, {
    onError: (error, {
      name
    }) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.slo.slo.delete.errorNotification', {
          defaultMessage: 'Failed to delete {name}',
          values: {
            name
          }
        })
      });
    },
    onSuccess: (_data, {
      name
    }) => {
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.lists(),
        exact: false
      });
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.allDefinitions(),
        exact: false
      });
      toasts.addSuccess(_i18n.i18n.translate('xpack.slo.slo.delete.successNotification', {
        defaultMessage: 'Deleted {name}',
        values: {
          name
        }
      }));
    }
  });
}