"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Configuration = Configuration;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _slo_selector = require("../alerts/slo_selector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Configuration({
  onCreate,
  onCancel
}) {
  const [selectedSlo, setSelectedSlo] = (0, _react.useState)();
  const [duration, setDuration] = (0, _react.useState)('1h');
  const [hasError, setHasError] = (0, _react.useState)(false);
  const isDurationValid = duration.match(/^\d+[mhd]$/); // matches 1m, 78m, 1h, 6h, 1d, 24d

  const isValid = !!selectedSlo && isDurationValid;
  const onConfirmClick = () => {
    if (isValid) {
      onCreate({
        sloId: selectedSlo.sloId,
        sloInstanceId: selectedSlo.sloInstanceId,
        duration
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onCancel,
    style: {
      minWidth: 550
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.slo.burnRateEmbeddable.configuration.headerTitle', {
    defaultMessage: 'Burn rate configuration'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_slo_selector.SloSelector, {
    singleSelection: true,
    hasError: hasError,
    onSelected: slo => {
      setHasError(slo === undefined);
      if (slo && 'id' in slo) {
        setSelectedSlo({
          sloId: slo.id,
          sloInstanceId: slo.instanceId
        });
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: !isDurationValid,
    label: _i18n.i18n.translate('xpack.slo.burnRateEmbeddable.configuration.durationLabel', {
      defaultMessage: 'Duration'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "sloConfigurationDuration",
    placeholder: "1h",
    value: duration,
    onChange: e => setDuration(e.target.value),
    isInvalid: !isDurationValid,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.slo.burnRateEmbeddable.configuration.durationTooltip', {
        defaultMessage: 'Duration must be in the format of [value][unit], for example 5m, 3h, or 6d'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "question"
    }))
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "sloConfigurationCancelButton",
    onClick: onCancel
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.burnRateEmbeddable.configuration.cancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "sloConfigurationConfirmButton",
    isDisabled: !isValid || hasError,
    onClick: onConfirmClick,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.slo.burnRateEmbeddable.configuration.cancelButtonLabel",
    defaultMessage: "Confirm"
  })))));
}