"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getESQueryForLogRateAnalysis = void 0;
var _sloSchema = require("@kbn/slo-schema");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/observability-plugin/public");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getESQueryForLogRateAnalysis = (params, groupBy, groupings) => {
  const {
    filter,
    good,
    total
  } = params;
  const filterKuery = _sloSchema.kqlWithFiltersSchema.is(filter) ? filter.kqlQuery : filter;
  const filterFilters = [];
  if (_sloSchema.kqlWithFiltersSchema.is(filter)) {
    filter.filters.forEach(i => filterFilters.push(i));
  }
  const goodKuery = _sloSchema.kqlWithFiltersSchema.is(good) ? good.kqlQuery : good;
  const goodFilters = _sloSchema.kqlWithFiltersSchema.is(good) ? good.filters : [];
  const totalKuery = _sloSchema.kqlWithFiltersSchema.is(total) ? total.kqlQuery : total;
  const totalFilters = _sloSchema.kqlWithFiltersSchema.is(total) ? total.filters : [];
  const customGoodFilter = (0, _public.buildEsQuery)({
    kuery: goodKuery,
    filters: goodFilters
  });
  const customTotalFilter = (0, _public.buildEsQuery)({
    kuery: totalKuery,
    filters: totalFilters
  });
  const customFilters = (0, _public.buildEsQuery)({
    kuery: filterKuery,
    filters: filterFilters
  });
  const groupByFilters = [];
  if (groupBy && groupings) {
    const groupByFields = [groupBy].flat();
    if (!(0, _lodash.isEmpty)(groupings) && groupByFields && groupByFields.length > 0 && groupByFields.every(field => field === _sloSchema.ALL_VALUE) === false) {
      groupByFields.forEach(field => {
        groupByFilters.push({
          meta: {
            disabled: false,
            negate: false,
            alias: null,
            key: field,
            params: {
              query: groupings[field]
            },
            type: 'phrase',
            index: params.index
          },
          $state: {
            store: _esQuery.FilterStateStore.APP_STATE
          },
          query: {
            match_phrase: {
              [field]: groupings[field]
            }
          }
        });
      });
    }
  }
  const customGroupByFilters = (0, _public.buildEsQuery)({
    kuery: '',
    filters: groupByFilters
  });
  const finalQuery = {
    bool: {
      filter: [customTotalFilter, customFilters, customGroupByFilters],
      must_not: customGoodFilter
    }
  };
  return finalQuery;
};
exports.getESQueryForLogRateAnalysis = getESQueryForLogRateAnalysis;