"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      size,
      colors,
      border
    } = euiTheme;
    const container = {
      margin: `${size.xs} ${size.base} ${size.base} ${size.xs}`,
      color: colors.text,
      padding: `${size.s} 0`,
      borderStyle: 'solid',
      borderColor: colors.lightShade,
      borderWidth: border.width.thin,
      borderRadius: border.radius.medium,
      maxHeight: 378,
      overflowY: 'auto',
      backgroundColor: colors.emptyShade
    };
    return {
      container
    };
  }, [euiTheme]);
  return cached;
};
exports.useStyles = useStyles;