"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanelListItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("./styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Detail panel description list item.
 */
const DetailPanelListItem = ({
  children,
  copy,
  display = 'grid'
}) => {
  const [isHovered, setIsHovered] = (0, _react.useState)(false);
  const styles = (0, _styles.useStyles)({
    display
  });
  const props = {
    size: 's',
    css: !!copy ? styles.copiableItem : styles.item
  };
  if (!!copy) {
    props.onMouseEnter = () => setIsHovered(true);
    props.onMouseLeave = () => setIsHovered(false);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, (0, _extends2.default)({}, props, {
    "data-test-subj": "sessionView:detail-panel-list-item"
  }), children, isHovered && copy);
};
exports.DetailPanelListItem = DetailPanelListItem;