"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditConnectorConfiguration = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("../use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEditConnectorConfiguration = connectorId => {
  const {
    http
  } = (0, _use_kibana.useKibanaServices)();
  return (0, _reactQuery.useMutation)({
    mutationFn: async configuration => {
      const body = {
        configuration
      };
      const result = await http.post(`/internal/serverless_search/connectors/${connectorId}/configuration`, {
        body: JSON.stringify(body)
      });
      return result;
    }
  });
};
exports.useEditConnectorConfiguration = useEditConnectorConfiguration;