"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorIngestionPanel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchApiPanels = require("@kbn/search-api-panels");
var _react = _interopRequireDefault(require("react"));
var _use_create_connector = require("../hooks/api/use_create_connector");
var _use_connectors = require("../hooks/api/use_connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorIngestionPanel = ({
  assetBasePath
}) => {
  const {
    createConnector
  } = (0, _use_create_connector.useCreateConnector)();
  const {
    data
  } = (0, _use_connectors.useConnectors)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "spaceEvenly",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h6", null, _i18n.i18n.translate('xpack.serverlessSearch.ingestData.alternativeOptions.connectorsTitle', {
    defaultMessage: 'Connectors'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.serverlessSearch.ingestData.alternativeOptions.connectorsDescription', {
    defaultMessage: 'Sync third-party data sources to Elasticsearch, by deploying open code Elastic connectors on your own infrastructure.  '
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexStart",
    alignItems: "center"
  }, Boolean(data === null || data === void 0 ? void 0 : data.canManageConnectors) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "serverlessSearchConnectorIngestionPanelSetUpAConnectorLink",
    onClick: () => createConnector()
  }, _i18n.i18n.translate('xpack.serverlessSearch.ingestData.alternativeOptions.setupConnectorLabel', {
    defaultMessage: 'Set up a connector'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_searchApiPanels.GithubLink, {
    href: "https://github.com/elastic/connectors",
    label: "connectors",
    assetBasePath: assetBasePath
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: "logoDocker"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "serverlessSearchConnectorIngestionPanelDockerLink",
    target: "_blank",
    href: "https://github.com/elastic/connectors-python/blob/main/docs/DOCKER.md"
  }, _i18n.i18n.translate('xpack.serverlessSearch.ingestData.alternativeOptions.connectorDockerLabel', {
    defaultMessage: 'Docker'
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.ConnectorIngestionPanel = ConnectorIngestionPanel;