"use strict";

var t = _interopRequireWildcard(require("io-ts"));
var _zod = require("@kbn/zod");
var _server = require("@kbn/core/server");
var _rxjs = require("rxjs");
var _create_server_route_factory = require("./create_server_route_factory");
var _decode_request_params = require("./decode_request_params");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function assertType(value) {
  return value;
}

// If a params codec is not set, its type should not be available in
// the request handler.
(0, _create_server_route_factory.createServerRouteFactory)()({
  endpoint: 'GET /internal/endpoint_without_params',
  handler: async resources => {
    // @ts-expect-error Argument of type '{}' is not assignable to parameter of type '{ params: any; }'.
    assertType(resources);
  }
});

// If a params codec is set, its type _should_ be available in the
// request handler.
(0, _create_server_route_factory.createServerRouteFactory)()({
  endpoint: 'GET /internal/endpoint_with_params',
  params: t.type({
    path: t.type({
      serviceName: t.string
    })
  }),
  handler: async resources => {
    assertType(resources);
  }
});
(0, _create_server_route_factory.createServerRouteFactory)()({
  endpoint: 'GET /internal/endpoint_with_params',
  params: _zod.z.object({
    path: _zod.z.object({
      serviceName: _zod.z.string()
    })
  }),
  handler: async resources => {
    assertType(resources);
  }
});

// Resources should be passed to the request handler.
(0, _create_server_route_factory.createServerRouteFactory)()({
  endpoint: 'GET /internal/endpoint_with_params',
  params: t.type({
    path: t.type({
      serviceName: t.string
    })
  }),
  handler: async ({
    context
  }) => {
    const spaceId = context.getSpaceId();
    assertType(spaceId);
  }
});
(0, _create_server_route_factory.createServerRouteFactory)()({
  endpoint: 'GET /internal/endpoint_with_params',
  params: _zod.z.object({
    path: _zod.z.object({
      serviceName: _zod.z.string()
    })
  }),
  handler: async ({
    context
  }) => {
    const spaceId = context.getSpaceId();
    assertType(spaceId);
  }
});

// Create options are available when registering a route.
(0, _create_server_route_factory.createServerRouteFactory)()({
  endpoint: 'GET /internal/endpoint_with_params',
  params: t.type({
    path: t.type({
      serviceName: t.string
    })
  }),
  handler: async resources => {
    assertType(resources);
  }
});

// Public APIs should be versioned
(0, _create_server_route_factory.createServerRouteFactory)()({
  // @ts-expect-error
  endpoint: 'GET /api/endpoint_with_params',
  tags: [],
  handler: async resources => {}
});

// `access` is respected
(0, _create_server_route_factory.createServerRouteFactory)()({
  endpoint: 'GET /api/endpoint_with_params',
  options: {
    tags: [],
    access: 'internal'
  },
  handler: async resources => {}
});

// specifying additional options makes them required
// @ts-expect-error
(0, _create_server_route_factory.createServerRouteFactory)()({
  endpoint: 'GET /api/endpoint_with_params 2023-10-31',
  handler: async resources => {}
});
(0, _create_server_route_factory.createServerRouteFactory)()({
  endpoint: 'GET /api/endpoint_with_params 2023-10-31',
  options: {
    tags: []
  },
  handler: async resources => {}
});

// cannot return observables that are not in the SSE structure
const route = (0, _create_server_route_factory.createServerRouteFactory)()({
  endpoint: 'POST /internal/endpoint_returning_observable_without_sse_structure',
  // @ts-expect-error
  handler: async () => {
    return (0, _rxjs.of)({
      streamed_response: true
    });
  }
});
const createServerRoute = (0, _create_server_route_factory.createServerRouteFactory)();
const repository = {
  ...createServerRoute({
    endpoint: 'GET /internal/endpoint_without_params',
    handler: async () => {
      return {
        noParamsForMe: true
      };
    }
  }),
  ...createServerRoute({
    endpoint: 'GET /internal/endpoint_with_params',
    params: t.type({
      path: t.type({
        serviceName: t.string
      })
    }),
    handler: async () => {
      return {
        yesParamsForMe: true
      };
    }
  }),
  ...createServerRoute({
    endpoint: 'GET /internal/endpoint_with_optional_params',
    params: t.partial({
      query: t.partial({
        serviceName: t.string
      })
    }),
    handler: async () => {
      return {
        someParamsForMe: true
      };
    }
  }),
  ...createServerRoute({
    endpoint: 'GET /internal/endpoint_with_params_zod',
    params: _zod.z.object({
      path: _zod.z.object({
        serviceName: _zod.z.string()
      })
    }),
    handler: async () => {
      return {
        yesParamsForMe: true
      };
    }
  }),
  ...createServerRoute({
    endpoint: 'GET /internal/endpoint_with_optional_params_zod',
    params: _zod.z.object({
      path: _zod.z.object({
        serviceName: _zod.z.string()
      }).partial()
    }).partial(),
    handler: async () => {
      return {
        someParamsForMe: true
      };
    }
  }),
  ...createServerRoute({
    endpoint: 'GET /internal/endpoint_returning_result',
    handler: async () => {
      return {
        result: true
      };
    }
  }),
  ...createServerRoute({
    endpoint: 'GET /internal/endpoint_returning_kibana_response',
    handler: async () => {
      return _server.kibanaResponseFactory.ok({
        body: {
          result: true
        }
      });
    }
  }),
  ...createServerRoute({
    endpoint: 'POST /internal/endpoint_returning_observable',
    handler: async () => {
      return (0, _rxjs.of)({
        type: 'foo',
        streamed_response: true
      });
    }
  })
};
// EndpointOf should return all valid endpoints of a repository

assertType(['GET /internal/endpoint_with_params', 'GET /internal/endpoint_without_params', 'GET /internal/endpoint_with_optional_params', 'GET /internal/endpoint_with_params_zod', 'GET /internal/endpoint_with_optional_params_zod', 'GET /internal/endpoint_returning_result', 'GET /internal/endpoint_returning_kibana_response']);

// @ts-expect-error Type '"this_endpoint_does_not_exist"' is not assignable to type '"endpoint_without_params" | "endpoint_with_params" | "endpoint_with_optional_params"'
assertType(['this_endpoint_does_not_exist']);

// ReturnOf should return the return type of a request handler.

assertType({
  noParamsForMe: true
});
const noParamsInvalid = {
  // @ts-expect-error type '{ paramsForMe: boolean; }' is not assignable to type '{ noParamsForMe: boolean; }'.
  paramsForMe: true
};
assertType({
  result: true
});
assertType({
  result: true
});

// RouteRepositoryClient

const client = {};

// It should respect any additional create options.

// @ts-expect-error Property 'timeout' is missing
client.fetch('GET /internal/endpoint_without_params', {});
client.fetch('GET /internal/endpoint_without_params', {
  timeout: 1
});

// It does not allow params for routes without a params codec
client.fetch('GET /internal/endpoint_without_params', {
  // @ts-expect-error Object literal may only specify known properties, and 'params' does not exist in type
  params: {},
  timeout: 1
});

// It requires params for routes with a params codec
client.fetch('GET /internal/endpoint_with_params', {
  params: {
    // @ts-expect-error property 'serviceName' is missing in type '{}'
    path: {}
  },
  timeout: 1
});
client.fetch('GET /internal/endpoint_with_params_zod', {
  params: {
    // @ts-expect-error property 'serviceName' is missing in type '{}'
    path: {}
  },
  timeout: 1
});

// Params are optional if the codec has no required keys
client.fetch('GET /internal/endpoint_with_optional_params', {
  timeout: 1
});
client.fetch('GET /internal/endpoint_with_optional_params_zod', {
  timeout: 1
});

// If optional, an error will still occur if the params do not match
client.fetch('GET /internal/endpoint_with_optional_params', {
  timeout: 1,
  params: {
    // @ts-expect-error Object literal may only specify known properties, and 'path' does not exist in type
    path: ''
  }
});
client.fetch('GET /internal/endpoint_with_optional_params_zod', {
  timeout: 1,
  params: {
    // @ts-expect-error Object literal may only specify known properties, and 'path' does not exist in type
    path: ''
  }
});

// The return type is correctly inferred
client.fetch('GET /internal/endpoint_with_params', {
  params: {
    path: {
      serviceName: ''
    }
  },
  timeout: 1
}).then(res => {
  assertType(res);
  assertType(res);
});
client.fetch('GET /internal/endpoint_with_params_zod', {
  params: {
    path: {
      serviceName: ''
    }
  },
  timeout: 1
}).then(res => {
  assertType(res);
  assertType(res);
});
client.fetch('GET /internal/endpoint_returning_result', {
  timeout: 1
}).then(res => {
  assertType(res);
});
client.fetch('GET /internal/endpoint_returning_kibana_response', {
  timeout: 1
}).then(res => {
  assertType(res);
});

// decodeRequestParams should return the type of the codec that is passed
assertType((0, _decode_request_params.decodeRequestParams)({
  path: {
    serviceName: 'serviceName'
  },
  body: undefined,
  query: undefined
}, t.type({
  path: t.type({
    serviceName: t.string
  })
})));
assertType(
// @ts-expect-error The types of 'path.serviceName' are incompatible between these types.
(0, _decode_request_params.decodeRequestParams)({
  path: {
    serviceName: 'serviceName'
  },
  body: undefined,
  query: undefined
}, t.type({
  path: t.type({
    serviceName: t.string
  })
})));
assertType(client.stream('POST /internal/endpoint_returning_observable', {
  timeout: 10
}));