"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListItem = exports.List = void 0;
var _zod = require("@kbn/zod");
var _list_common = require("./list_common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: List Schemas
 *   version: not applicable
 */

const List = exports.List = _zod.z.object({
  id: _list_common.ListId,
  type: _list_common.ListType,
  name: _list_common.ListName,
  description: _list_common.ListDescription,
  serializer: _zod.z.string().optional(),
  deserializer: _zod.z.string().optional(),
  immutable: _zod.z.boolean(),
  meta: _list_common.ListMetadata.optional(),
  '@timestamp': _zod.z.string().datetime().optional(),
  version: _zod.z.number().int().min(1),
  _version: _zod.z.string().optional(),
  tie_breaker_id: _zod.z.string(),
  created_at: _zod.z.string().datetime(),
  created_by: _zod.z.string(),
  updated_at: _zod.z.string().datetime(),
  updated_by: _zod.z.string()
});
const ListItem = exports.ListItem = _zod.z.object({
  id: _list_common.ListItemId,
  type: _list_common.ListType,
  list_id: _list_common.ListId,
  value: _list_common.ListItemValue,
  serializer: _zod.z.string().optional(),
  deserializer: _zod.z.string().optional(),
  meta: _list_common.ListItemMetadata.optional(),
  '@timestamp': _zod.z.string().datetime().optional(),
  _version: _zod.z.string().optional(),
  tie_breaker_id: _zod.z.string(),
  created_at: _zod.z.string().datetime(),
  created_by: _zod.z.string(),
  updated_at: _zod.z.string().datetime(),
  updated_by: _zod.z.string()
});