"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSolutionNavigation = void 0;
var Rx = _interopRequireWildcard(require("rxjs"));
var _product = require("../../common/product");
var _ai_navigation_tree = require("./ai_navigation/ai_navigation_tree");
var _navigation_tree = require("./navigation_tree");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSolutionNavigation = async (services, productTypes) => {
  const shouldUseAINavigation = productTypes.some(productType => productType.product_tier === _product.ProductTier.searchAiLake);
  const navigationTree = shouldUseAINavigation ? (0, _ai_navigation_tree.createAiNavigationTree)() : (0, _navigation_tree.createNavigationTree)(services);
  services.securitySolution.setSolutionNavigationTree(navigationTree);
  services.serverless.initNavigation('security', Rx.of(navigationTree), {
    dataTestSubj: 'securitySolutionSideNav'
  });
};
exports.registerSolutionNavigation = registerSolutionNavigation;