"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLegacySiemSignalsUsage = void 0;
var _get_non_migrated_signals_info = require("../../../lib/detection_engine/migrations/get_non_migrated_signals_info");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLegacySiemSignalsUsage = async ({
  signalsIndex,
  esClient,
  logger
}) => {
  const {
    indices,
    spaces
  } = await (0, _get_non_migrated_signals_info.getNonMigratedSignalsInfo)({
    esClient,
    signalsIndex,
    logger
  });
  return {
    non_migrated_indices_total: indices.length,
    spaces_total: spaces.length
  };
};
exports.getLegacySiemSignalsUsage = getLegacySiemSignalsUsage;