"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usersFactory = void 0;
var _users = require("../../../../../common/search_strategy/security_solution/users");
var _all = require("./all");
var _authentications = require("./authentications");
var _managed_details = require("./managed_details");
var _observed_details = require("./observed_details");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usersFactory = exports.usersFactory = {
  [_users.UsersQueries.observedDetails]: _observed_details.observedUserDetails,
  [_users.UsersQueries.managedDetails]: _managed_details.managedUserDetails,
  [_users.UsersQueries.users]: _all.allUsers,
  [_users.UsersQueries.authentications]: _authentications.authentications
};