"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelinesRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../../common/constants");
var _utils = require("../../../../detection_engine/routes/utils");
var _common = require("../../../utils/common");
var _timelines = require("../../../saved_object/timelines");
var _timeline = require("../../../../../../common/api/timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTimelinesRoute = router => {
  router.versioned.get({
    path: _constants.TIMELINES_URL,
    security: {
      authz: {
        requiredPrivileges: ['timeline_read']
      }
    },
    access: 'public'
  }).addVersion({
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_timeline.GetTimelinesRequestQuery)
      }
    },
    version: '2023-10-31'
  }, async (context, request, response) => {
    try {
      var _request$query, _request$query2, _request$query3, _request$query$search, _request$query4, _request$query$sort_f, _request$query5, _request$query$sort_o, _request$query6, _request$query$status, _request$query7, _request$query$timeli, _request$query8, _ref, _res;
      const frameworkRequest = await (0, _common.buildFrameworkRequest)(context, request);
      const onlyUserFavorite = ((_request$query = request.query) === null || _request$query === void 0 ? void 0 : _request$query.only_user_favorite) === 'true';
      const pageSize = (_request$query2 = request.query) !== null && _request$query2 !== void 0 && _request$query2.page_size ? parseInt(request.query.page_size, 10) : null;
      const pageIndex = (_request$query3 = request.query) !== null && _request$query3 !== void 0 && _request$query3.page_index ? parseInt(request.query.page_index, 10) : null;
      const search = (_request$query$search = (_request$query4 = request.query) === null || _request$query4 === void 0 ? void 0 : _request$query4.search) !== null && _request$query$search !== void 0 ? _request$query$search : null;
      const sortField = (_request$query$sort_f = (_request$query5 = request.query) === null || _request$query5 === void 0 ? void 0 : _request$query5.sort_field) !== null && _request$query$sort_f !== void 0 ? _request$query$sort_f : null;
      const sortOrder = (_request$query$sort_o = (_request$query6 = request.query) === null || _request$query6 === void 0 ? void 0 : _request$query6.sort_order) !== null && _request$query$sort_o !== void 0 ? _request$query$sort_o : null;
      const status = (_request$query$status = (_request$query7 = request.query) === null || _request$query7 === void 0 ? void 0 : _request$query7.status) !== null && _request$query$status !== void 0 ? _request$query$status : null;
      const timelineType = (_request$query$timeli = (_request$query8 = request.query) === null || _request$query8 === void 0 ? void 0 : _request$query8.timeline_type) !== null && _request$query$timeli !== void 0 ? _request$query$timeli : null;
      const sort = sortField && sortOrder ? {
        sortField,
        sortOrder
      } : null;
      let res = null;
      let totalCount = null;
      if (pageSize == null && pageIndex == null) {
        const allActiveTimelines = await (0, _timelines.getAllTimeline)(frameworkRequest, false, {
          pageSize: 1,
          pageIndex: 1
        }, null, null, null, null);
        totalCount = allActiveTimelines.totalCount;
      }
      res = await (0, _timelines.getAllTimeline)(frameworkRequest, onlyUserFavorite, {
        pageSize: (_ref = pageSize !== null && pageSize !== void 0 ? pageSize : totalCount) !== null && _ref !== void 0 ? _ref : 1,
        pageIndex: pageIndex !== null && pageIndex !== void 0 ? pageIndex : 1
      }, search, sort, status, timelineType);
      return response.ok({
        body: (_res = res) !== null && _res !== void 0 ? _res : {}
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      const siemResponse = (0, _utils.buildSiemResponse)(response);
      return siemResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getTimelinesRoute = getTimelinesRoute;