"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTelemetryDiagnosticTimelineTaskConfig = createTelemetryDiagnosticTimelineTaskConfig;
var _constants = require("../constants");
var _helpers = require("../helpers");
var _configuration = require("../configuration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createTelemetryDiagnosticTimelineTaskConfig() {
  const taskName = 'Security Solution Diagnostic Timeline telemetry';
  const taskType = 'security:telemetry-diagnostic-timelines';
  return {
    type: taskType,
    title: taskName,
    interval: '1h',
    timeout: '15m',
    version: '1.0.0',
    runTask: async (taskId, logger, receiver, sender, taskMetricsService, taskExecutionPeriod) => {
      const mdc = {
        task_id: taskId,
        task_execution_period: taskExecutionPeriod
      };
      const log = (0, _helpers.newTelemetryLogger)(logger.get('timelines_diagnostic'), mdc);
      const trace = taskMetricsService.start(taskType);
      const fetcher = new _helpers.TelemetryTimelineFetcher(receiver);
      log.debug('Running telemetry task');
      try {
        let counter = 0;
        const {
          rangeFrom,
          rangeTo
        } = (0, _helpers.ranges)(taskExecutionPeriod);
        const alerts = receiver.fetchTimelineAlerts(_constants.DEFAULT_DIAGNOSTIC_INDEX, rangeFrom, rangeTo, _configuration.telemetryConfiguration.query_config);
        for await (const page of alerts) {
          log.debug('found alerts to process', {
            length: page.length
          });
          for (const alert of page) {
            var _sender$getTelemetryU, _sender$getTelemetryU2;
            const result = await fetcher.fetchTimeline(alert);
            (_sender$getTelemetryU = sender.getTelemetryUsageCluster()) === null || _sender$getTelemetryU === void 0 ? void 0 : _sender$getTelemetryU.incrementCounter({
              counterName: 'telemetry_timeline_diagnostic',
              counterType: 'timeline_diagnostic_node_count',
              incrementBy: result.nodes
            });
            (_sender$getTelemetryU2 = sender.getTelemetryUsageCluster()) === null || _sender$getTelemetryU2 === void 0 ? void 0 : _sender$getTelemetryU2.incrementCounter({
              counterName: 'telemetry_timeline_diagnostic',
              counterType: 'timeline_diagnostic_event_count',
              incrementBy: result.events
            });
            if (result.timeline) {
              await sender.sendOnDemand(_constants.TELEMETRY_CHANNEL_TIMELINE, [result.timeline]);
              counter += 1;
            } else {
              log.debug('no events in timeline');
            }
          }
        }
        log.debug('Concluding timeline task.', {
          counter
        });
        await taskMetricsService.end(trace);
        return counter;
      } catch (error) {
        log.error('could not complete task', (0, _helpers.withErrorMessage)(error));
        await taskMetricsService.end(trace, error);
        return 0;
      }
    }
  };
}