"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseCircuitBreaker = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class BaseCircuitBreaker {
  // helper function to create a success result
  success() {
    return {
      circuitBreaker: this.constructor.name,
      valid: true
    };
  }

  // helper function to create a failure result
  failure(message) {
    return {
      circuitBreaker: this.constructor.name,
      valid: false,
      message
    };
  }
}
exports.BaseCircuitBreaker = BaseCircuitBreaker;