"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrebuiltRulesRetriever = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PrebuiltRulesRetriever {
  constructor(clients) {
    (0, _defineProperty2.default)(this, "rulesMap", void 0);
    this.clients = clients;
  }
  async populateIndex() {
    if (!this.rulesMap) {
      this.rulesMap = await this.clients.data.prebuiltRules.getRuleVersionsMap();
    }
    return this.clients.data.prebuiltRules.populate(this.rulesMap);
  }
  async search(semanticString, techniqueIds) {
    if (!this.rulesMap) {
      this.rulesMap = await this.clients.data.prebuiltRules.getRuleVersionsMap();
    }
    const results = await this.clients.data.prebuiltRules.search(semanticString, techniqueIds);
    return results.map(rule => {
      var _this$rulesMap$get, _this$rulesMap;
      const versions = (_this$rulesMap$get = (_this$rulesMap = this.rulesMap) === null || _this$rulesMap === void 0 ? void 0 : _this$rulesMap.get(rule.rule_id)) !== null && _this$rulesMap$get !== void 0 ? _this$rulesMap$get : {};
      return {
        ...rule,
        ...versions
      };
    });
  }
}
exports.PrebuiltRulesRetriever = PrebuiltRulesRetriever;