"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInlineQueryNode = void 0;
var _output_parsers = require("@langchain/core/output_parsers");
var _fp = require("lodash/fp");
var _prompts = require("./prompts");
var _comments = require("../../../../../util/comments");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInlineQueryNode = ({
  model,
  logger
}) => {
  return async state => {
    var _response$match$1$tri, _response$match, _response$match$, _response$match2;
    const query = state.original_rule.query;
    // Check before to avoid unnecessary LLM calls
    let unsupportedComment = getUnsupportedComment(query);
    if (unsupportedComment) {
      return {
        inline_query: undefined,
        // No inline query if unsupported to jump to the end of the graph
        comments: [(0, _comments.generateAssistantComment)(unsupportedComment)]
      };
    }
    if ((0, _fp.isEmpty)(state.resources)) {
      // No resources identified in the query, no need to replace
      return {
        inline_query: query
      };
    }
    const replaceQueryParser = new _output_parsers.StringOutputParser();
    const replaceQueryResourcePrompt = _prompts.REPLACE_QUERY_RESOURCE_PROMPT.pipe(model).pipe(replaceQueryParser);
    const resourceContext = (0, _prompts.getResourcesContext)(state.resources);
    const response = await replaceQueryResourcePrompt.invoke({
      query: state.original_rule.query,
      macros: resourceContext.macros,
      lookups: resourceContext.lookups
    });
    const inlineQuery = (_response$match$1$tri = (_response$match = response.match(/```spl\n([\s\S]*?)\n```/)) === null || _response$match === void 0 ? void 0 : _response$match[1].trim()) !== null && _response$match$1$tri !== void 0 ? _response$match$1$tri : '';
    if (!inlineQuery) {
      logger.warn('Failed to retrieve inline query');
      const summary = '## Inlining Summary\n\nFailed to retrieve inline query';
      return {
        inline_query: query,
        comments: [(0, _comments.generateAssistantComment)(summary)]
      };
    }

    // Check after replacing in case the replacements made it untranslatable
    unsupportedComment = getUnsupportedComment(inlineQuery);
    if (unsupportedComment) {
      return {
        inline_query: undefined,
        // No inline query if unsupported to jump to the end of the graph
        comments: [(0, _comments.generateAssistantComment)(unsupportedComment)]
      };
    }
    const inliningSummary = (_response$match$ = (_response$match2 = response.match(/## Inlining Summary[\s\S]*$/)) === null || _response$match2 === void 0 ? void 0 : _response$match2[0]) !== null && _response$match$ !== void 0 ? _response$match$ : '';
    return {
      inline_query: inlineQuery,
      comments: [(0, _comments.generateAssistantComment)((0, _comments.cleanMarkdown)(inliningSummary))]
    };
  };
};
exports.getInlineQueryNode = getInlineQueryNode;
const getUnsupportedComment = query => {
  const unsupportedText = '## Translation Summary\nCan not create custom translation.\n';
  if (query.includes(' inputlookup')) {
    return `${unsupportedText}Reason: \`inputlookup\` command is not supported.`;
  }
};