"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSharedExceptionListRoute = void 0;
var _uuid = require("uuid");
var _zodHelpers = require("@kbn/zod-helpers");
var _api = require("@kbn/securitysolution-exceptions-common/api");
var _constants = require("../../../../../common/constants");
var _utils = require("../../../detection_engine/routes/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createSharedExceptionListRoute = router => {
  router.versioned.post({
    path: _constants.SHARED_EXCEPTION_LIST_URL,
    access: 'public',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: '2023-10-31',
    validate: {
      request: {
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_api.CreateSharedExceptionListRequestBody)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const {
      description,
      name
    } = request.body;
    try {
      const ctx = await context.resolve(['core', 'securitySolution', 'alerting', 'licensing', 'lists']);
      const listsClient = ctx.securitySolution.getExceptionListClient();
      const createdSharedList = await (listsClient === null || listsClient === void 0 ? void 0 : listsClient.createExceptionList({
        description,
        immutable: false,
        listId: (0, _uuid.v4)(),
        meta: undefined,
        name,
        namespaceType: 'single',
        tags: [],
        type: 'detection',
        version: 1
      }));
      return response.ok({
        body: _api.CreateSharedExceptionListResponse.parse(createdSharedList)
      });
    } catch (exc) {
      return siemResponse.error({
        body: exc.message,
        statusCode: 404
      });
    }
  });
};
exports.createSharedExceptionListRoute = createSharedExceptionListRoute;