"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.totalFieldsLimit = exports.riskScoreFieldMap = exports.nameSpaceAwareMappingsComponentName = exports.mappingComponentName = exports.getTransformOptions = exports.getIndexPatternDataStream = void 0;
var _types = require("../../../../common/entity_analytics/types");
var _risk_engine = require("../../../../common/entity_analytics/risk_engine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const commonRiskFields = {
  id_field: {
    type: 'keyword',
    array: false,
    required: false
  },
  id_value: {
    type: 'keyword',
    array: false,
    required: false
  },
  calculated_level: {
    type: 'keyword',
    array: false,
    required: false
  },
  calculated_score: {
    type: 'float',
    array: false,
    required: false
  },
  calculated_score_norm: {
    type: 'float',
    array: false,
    required: false
  },
  category_1_score: {
    type: 'float',
    array: false,
    required: false
  },
  category_1_count: {
    type: 'long',
    array: false,
    required: false
  },
  inputs: {
    type: 'object',
    array: true,
    required: false
  },
  'inputs.id': {
    type: 'keyword',
    array: false,
    required: false
  },
  'inputs.index': {
    type: 'keyword',
    array: false,
    required: false
  },
  'inputs.category': {
    type: 'keyword',
    array: false,
    required: false
  },
  'inputs.description': {
    type: 'keyword',
    array: false,
    required: false
  },
  'inputs.risk_score': {
    type: 'float',
    array: false,
    required: false
  },
  'inputs.timestamp': {
    type: 'date',
    array: false,
    required: false
  },
  notes: {
    type: 'keyword',
    array: false,
    required: false
  }
};
const buildIdentityRiskFields = identifierType => Object.keys(commonRiskFields).reduce((fieldMap, key) => {
  const identifierKey = `${identifierType}.risk.${key}`;
  fieldMap[identifierKey] = commonRiskFields[key];
  return fieldMap;
}, {});
const riskScoreFieldMap = exports.riskScoreFieldMap = {
  '@timestamp': {
    type: 'date',
    array: false,
    required: false
  },
  'event.ingested': {
    type: 'date',
    array: false,
    required: false
  },
  'host.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'host.risk': {
    type: 'object',
    array: false,
    required: false
  },
  ...buildIdentityRiskFields(_types.EntityType.host),
  'user.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'user.risk': {
    type: 'object',
    array: false,
    required: false
  },
  ...buildIdentityRiskFields(_types.EntityType.user),
  'service.name': {
    type: 'keyword',
    array: false,
    required: false
  },
  'service.risk': {
    type: 'object',
    array: false,
    required: false
  },
  ...buildIdentityRiskFields(_types.EntityType.service)
};
const mappingComponentName = exports.mappingComponentName = '.risk-score-mappings';
const nameSpaceAwareMappingsComponentName = namespace => {
  return `${mappingComponentName}-${namespace}`;
};
exports.nameSpaceAwareMappingsComponentName = nameSpaceAwareMappingsComponentName;
const totalFieldsLimit = exports.totalFieldsLimit = 1000;
const getIndexPatternDataStream = namespace => ({
  template: `.${_risk_engine.riskScoreBaseIndexName}.${_risk_engine.riskScoreBaseIndexName}-${namespace}-index-template`,
  alias: `${_risk_engine.riskScoreBaseIndexName}.${_risk_engine.riskScoreBaseIndexName}-${namespace}`
});
exports.getIndexPatternDataStream = getIndexPatternDataStream;
/**
 * WARNING: We must increase the version when changing any configuration
 *
 * The risk engine starts the transforms executions after writing the documents to the risk score index.
 * So the transform don't need to run on a schedule.
 */
const getTransformOptions = ({
  dest,
  source
}) => ({
  dest: {
    index: dest
  },
  latest: {
    sort: '@timestamp',
    unique_key: [`host.name`, `user.name`, `service.name`]
  },
  source: {
    index: source,
    query: {
      bool: {
        filter: [{
          range: {
            '@timestamp': {
              // It prevents the transform from processing too much data on reinstall
              gte: 'now-24h'
            }
          }
        }]
      }
    }
  },
  frequency: '1h',
  // 1h is the maximum value
  sync: {
    time: {
      delay: '0s',
      // It doesn't have any delay because the risk engine writes the documents to the index and schedules the transform synchronously.
      field: '@timestamp'
    }
  },
  settings: {
    unattended: true // In unattended mode, the transform retries indefinitely in case of an error
  },
  _meta: {
    version: 3,
    // When this field is updated we automatically update the transform
    managed: true,
    // Metadata that identifies the transform. It has no functionality
    managed_by: 'security-entity-analytics' // Metadata that identifies the transform. It has no functionality
  }
});
exports.getTransformOptions = getTransformOptions;