"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskEngineSettingsRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
var _audit = require("../../audit");
var _audit2 = require("../audit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const riskEngineSettingsRoute = router => {
  router.versioned.get({
    access: 'internal',
    path: _constants.RISK_ENGINE_SETTINGS_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: '1',
    validate: {}
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const securitySolution = await context.securitySolution;
    const riskEngineClient = securitySolution.getRiskEngineDataClient();
    try {
      var _securitySolution$get;
      const result = await riskEngineClient.getConfiguration();
      (_securitySolution$get = securitySolution.getAuditLogger()) === null || _securitySolution$get === void 0 ? void 0 : _securitySolution$get.log({
        message: 'User accessed risk engine configuration information',
        event: {
          action: _audit2.RiskEngineAuditActions.RISK_ENGINE_CONFIGURATION_GET,
          category: _audit.AUDIT_CATEGORY.DATABASE,
          type: _audit.AUDIT_TYPE.ACCESS,
          outcome: _audit.AUDIT_OUTCOME.SUCCESS
        }
      });
      if (!result) {
        throw new Error('Unable to get risk engine configuration');
      }
      return response.ok({
        body: {
          range: result.range,
          includeClosedAlerts: Array.isArray(result === null || result === void 0 ? void 0 : result.excludeAlertStatuses) && !result.excludeAlertStatuses.includes('closed')
        }
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: {
          message: error.message,
          full_error: JSON.stringify(e)
        },
        bypassErrorFormat: true
      });
    }
  });
};
exports.riskEngineSettingsRoute = riskEngineSettingsRoute;