"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userEntityEngineDescription = exports.USER_IDENTITY_FIELD = exports.USER_DEFINITION_VERSION = void 0;
var _common = require("./common");
var _field_utils = require("./field_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USER_DEFINITION_VERSION = exports.USER_DEFINITION_VERSION = '1.0.0';
const USER_IDENTITY_FIELD = exports.USER_IDENTITY_FIELD = 'user.name';
const userEntityEngineDescription = exports.userEntityEngineDescription = {
  entityType: 'user',
  version: USER_DEFINITION_VERSION,
  identityField: USER_IDENTITY_FIELD,
  identityFieldMapping: {
    type: 'keyword',
    fields: {
      text: {
        type: 'match_only_text'
      }
    }
  },
  settings: {
    timestampField: '@timestamp'
  },
  fields: [(0, _field_utils.collectValues)({
    source: 'user.domain'
  }), (0, _field_utils.collectValues)({
    source: 'user.email'
  }), (0, _field_utils.collectValues)({
    source: 'user.full_name',
    mapping: {
      type: 'keyword',
      fields: {
        text: {
          type: 'match_only_text'
        }
      }
    }
  }), (0, _field_utils.collectValues)({
    source: 'user.hash'
  }), (0, _field_utils.collectValues)({
    source: 'user.id'
  }), (0, _field_utils.collectValues)({
    source: 'user.roles'
  }), ...(0, _common.getCommonFieldDescriptions)('user')]
};