"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceEntityEngineDescription = exports.SERVICE_IDENTITY_FIELD = exports.SERVICE_DEFINITION_VERSION = void 0;
var _common = require("./common");
var _field_utils = require("./field_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SERVICE_DEFINITION_VERSION = exports.SERVICE_DEFINITION_VERSION = '1.0.0';
const SERVICE_IDENTITY_FIELD = exports.SERVICE_IDENTITY_FIELD = 'service.name';
const serviceEntityEngineDescription = exports.serviceEntityEngineDescription = {
  entityType: 'service',
  version: SERVICE_DEFINITION_VERSION,
  identityField: SERVICE_IDENTITY_FIELD,
  identityFieldMapping: {
    type: 'keyword'
  },
  settings: {
    timestampField: '@timestamp'
  },
  fields: [(0, _field_utils.collectValues)({
    source: 'service.address'
  }), (0, _field_utils.collectValues)({
    source: 'service.environment'
  }), (0, _field_utils.collectValues)({
    source: 'service.ephemeral_id'
  }), (0, _field_utils.collectValues)({
    source: 'service.id'
  }), (0, _field_utils.collectValues)({
    source: 'service.node.name'
  }), (0, _field_utils.collectValues)({
    source: 'service.node.roles'
  }), (0, _field_utils.collectValues)({
    source: 'service.node.role'
  }), (0, _field_utils.newestValue)({
    source: 'service.state'
  }), (0, _field_utils.collectValues)({
    source: 'service.type'
  }), (0, _field_utils.newestValue)({
    source: 'service.version'
  }), ...(0, _common.getCommonFieldDescriptions)('service')]
};