"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCommonFieldDescriptions = void 0;
var _field_utils = require("./field_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCommonFieldDescriptions = entityType => {
  return [(0, _field_utils.oldestValue)({
    source: '_index',
    destination: 'entity.source'
  }), (0, _field_utils.newestValue)({
    source: 'asset.criticality'
  }), (0, _field_utils.newestValue)({
    source: `${entityType}.risk.calculated_level`
  }), (0, _field_utils.newestValue)({
    source: `${entityType}.risk.calculated_score`,
    mapping: {
      type: 'float'
    }
  }), (0, _field_utils.newestValue)({
    source: `${entityType}.risk.calculated_score_norm`,
    mapping: {
      type: 'float'
    }
  })];
};
exports.getCommonFieldDescriptions = getCommonFieldDescriptions;