"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleByRuleId = void 0;
var _find_rules = require("../../search/find_rules");
var _convert_alerting_rule_to_rule_response = require("../converters/convert_alerting_rule_to_rule_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRuleByRuleId = async ({
  rulesClient,
  ruleId
}) => {
  const findRuleResponse = await (0, _find_rules.findRules)({
    rulesClient,
    filter: `alert.attributes.params.ruleId: "${ruleId}"`,
    page: 1,
    fields: undefined,
    perPage: undefined,
    sortField: undefined,
    sortOrder: undefined
  });
  if (findRuleResponse.data.length === 0) {
    return null;
  }
  return (0, _convert_alerting_rule_to_rule_response.convertAlertingRuleToRuleResponse)(findRuleResponse.data[0]);
};
exports.getRuleByRuleId = getRuleByRuleId;