"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeRuleSource = exports.normalizeRuleParams = void 0;
var _utils = require("../../../utils/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Since there's no mechanism to migrate all rules at the same time,
 * we cannot guarantee that the ruleSource params is present in all rules.
 * This function will normalize the ruleSource param, creating it if does
 * not exist in ES, based on the immutable param.
 */
const normalizeRuleSource = ({
  immutable,
  ruleSource
}) => {
  if (!ruleSource) {
    const normalizedRuleSource = immutable ? {
      type: 'external',
      isCustomized: false
    } : {
      type: 'internal'
    };
    return normalizedRuleSource;
  }
  return ruleSource;
};
exports.normalizeRuleSource = normalizeRuleSource;
const normalizeRuleParams = params => {
  var _params$setup, _params$relatedIntegr, _params$requiredField;
  const investigationFields = (0, _utils.migrateLegacyInvestigationFields)(params.investigationFields);
  const ruleSource = normalizeRuleSource({
    immutable: params.immutable,
    ruleSource: params.ruleSource
  });
  return {
    ...params,
    // These fields are typed as optional in the data model, but they are required in our domain
    setup: (_params$setup = params.setup) !== null && _params$setup !== void 0 ? _params$setup : '',
    relatedIntegrations: (_params$relatedIntegr = params.relatedIntegrations) !== null && _params$relatedIntegr !== void 0 ? _params$relatedIntegr : [],
    requiredFields: (_params$requiredField = params.requiredFields) !== null && _params$requiredField !== void 0 ? _params$requiredField : [],
    // Fields to normalize
    investigationFields,
    ruleSource
  };
};
exports.normalizeRuleParams = normalizeRuleParams;