"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentStatusClient = void 0;
var _microsoft_defender_endpoint = require("./microsoft_defender_endpoint");
var _crowdstrike_agent_status_client = require("./crowdstrike/crowdstrike_agent_status_client");
var _sentinel_one_agent_status_client = require("./sentinel_one/sentinel_one_agent_status_client");
var _endpoint_agent_status_client = require("./endpoint/endpoint_agent_status_client");
var _errors = require("./errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieve a agent status  client for an agent type
 * @param agentType
 * @param constructorOptions
 *
 */
const getAgentStatusClient = (agentType, constructorOptions) => {
  switch (agentType) {
    case 'endpoint':
      return new _endpoint_agent_status_client.EndpointAgentStatusClient(constructorOptions);
    case 'sentinel_one':
      return new _sentinel_one_agent_status_client.SentinelOneAgentStatusClient(constructorOptions);
    case 'crowdstrike':
      return new _crowdstrike_agent_status_client.CrowdstrikeAgentStatusClient(constructorOptions);
    case 'microsoft_defender_endpoint':
      return new _microsoft_defender_endpoint.MicrosoftDefenderEndpointAgentStatusClient(constructorOptions);
    default:
      throw new _errors.UnsupportedAgentTypeError(`Agent type [${agentType}] does not support agent status`);
  }
};
exports.getAgentStatusClient = getAgentStatusClient;