"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointAgentStatusClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _utils = require("../../../../utils");
var _types = require("../../../../../../common/endpoint/types");
var _base_agent_status_client = require("../lib/base_agent_status_client");
var _actions = require("../../../actions");
var _errors = require("../errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EndpointAgentStatusClient extends _base_agent_status_client.AgentStatusClient {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "agentType", 'endpoint');
  }
  async getAgentStatuses(agentIds) {
    const soClient = this.options.soClient;
    const esClient = this.options.esClient;
    const metadataService = this.options.endpointService.getEndpointMetadataService(soClient.getCurrentNamespace());
    try {
      const agentIdsKql = agentIds.map(agentId => `agent.id: ${agentId}`).join(' or ');
      const [{
        data: hostInfoForAgents
      }, allPendingActions] = await Promise.all([metadataService.getHostMetadataList({
        page: 0,
        pageSize: 1000,
        kuery: agentIdsKql
      }), (0, _actions.getPendingActionsSummary)(esClient, metadataService, this.log, agentIds)]).catch(_utils.catchAndWrapError);
      return agentIds.reduce((acc, agentId) => {
        var _agentMetadata$metada, _pendingActions$pendi;
        const agentMetadata = hostInfoForAgents.find(hostInfo => hostInfo.metadata.agent.id === agentId);
        const pendingActions = allPendingActions.find(agentPendingActions => agentPendingActions.agent_id === agentId);
        acc[agentId] = {
          agentId,
          agentType: this.agentType,
          found: agentMetadata !== undefined,
          isolated: Boolean(agentMetadata === null || agentMetadata === void 0 ? void 0 : (_agentMetadata$metada = agentMetadata.metadata.Endpoint.state) === null || _agentMetadata$metada === void 0 ? void 0 : _agentMetadata$metada.isolation),
          lastSeen: (agentMetadata === null || agentMetadata === void 0 ? void 0 : agentMetadata.last_checkin) || '',
          pendingActions: (_pendingActions$pendi = pendingActions === null || pendingActions === void 0 ? void 0 : pendingActions.pending_actions) !== null && _pendingActions$pendi !== void 0 ? _pendingActions$pendi : {},
          status: (agentMetadata === null || agentMetadata === void 0 ? void 0 : agentMetadata.host_status) || _types.HostStatus.OFFLINE
        };
        return acc;
      }, {});
    } catch (err) {
      const error = new _errors.AgentStatusClientError(`Failed to fetch endpoint agent statuses for agentIds: [${agentIds.join()}], failed with: ${err.message}`, 500, err);
      this.log.error(error);
      throw error;
    }
  }
}
exports.EndpointAgentStatusClient = EndpointAgentStatusClient;