"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.links = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../common/constants");
var _translations = require("../app/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const links = exports.links = {
  id: _constants.SecurityPageName.timelines,
  title: _translations.TIMELINES,
  path: _constants.TIMELINES_PATH,
  globalNavPosition: 7,
  // It only makes sense to show this link when the user is also granted access to security solution
  capabilities: [[`${_constants.SECURITY_FEATURE_ID}.show`, `${_constants.TIMELINE_FEATURE_ID}.read`]],
  globalSearchKeywords: [_i18n.i18n.translate('xpack.securitySolution.appLinks.timelines', {
    defaultMessage: 'Timelines'
  })],
  links: [{
    id: _constants.SecurityPageName.timelinesTemplates,
    title: _i18n.i18n.translate('xpack.securitySolution.appLinks.timeline.templates', {
      defaultMessage: 'Templates'
    }),
    path: `${_constants.TIMELINES_PATH}/template`,
    sideNavDisabled: true,
    capabilities: [[`${_constants.SECURITY_FEATURE_ID}.show`, `${_constants.TIMELINE_FEATURE_ID}.read`]]
  }]
};