"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VerticalRule = exports.TabHeaderContainer = exports.StyledEuiFlyoutHeader = exports.FullWidthFlexGroup = exports.EventsCountBadge = void 0;
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabHeaderContainer = exports.TabHeaderContainer = _styledComponents.default.div`
  width: 100%;
`;
TabHeaderContainer.displayName = 'TimelineHeaderContainer';
const StyledEuiFlyoutHeader = exports.StyledEuiFlyoutHeader = (0, _styledComponents.default)(_eui.EuiFlyoutHeader)`
  align-items: stretch;
  box-shadow: none;
  display: flex;
  flex-direction: column;
  padding: 0;

  &.euiFlyoutHeader {
    ${({
  theme
}) => `padding: ${theme.eui.euiSizeS} 0 0 0;`}
  }
`;
const FullWidthFlexGroup = exports.FullWidthFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin: 0;
  width: 100%;
  overflow: hidden;
`;
const VerticalRule = exports.VerticalRule = _styledComponents.default.div`
  width: 2px;
  height: 100%;
  background: ${({
  theme
}) => theme.eui.euiColorLightShade};
`;
VerticalRule.displayName = 'VerticalRule';
const EventsCountBadge = exports.EventsCountBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeS};
`;