"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetflowColumns = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _source_destination = require("../../../../explore/network/components/source_destination");
var _duration_event_start_end = require("./duration_event_start_end");
var _user_process = require("./user_process");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EuiFlexItemMarginRight = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-right: 10px;
`;
EuiFlexItemMarginRight.displayName = 'EuiFlexItemMarginRight';

/**
 * Renders columns of draggable badges that describe both Netflow data, or more
 * generally, hosts interacting over a network connection. This component is
 * consumed by the `Netflow` visualization / row renderer.
 *
 * This component will allow columns to wrap if constraints on width prevent all
 * the columns from fitting on a single horizontal row
 */
const NetflowColumns = exports.NetflowColumns = /*#__PURE__*/_react.default.memo(({
  contextId,
  scopeId,
  destinationBytes,
  destinationGeoContinentName,
  destinationGeoCountryName,
  destinationGeoCountryIsoCode,
  destinationGeoRegionName,
  destinationGeoCityName,
  destinationIp,
  destinationPackets,
  destinationPort,
  eventDuration,
  eventId,
  eventEnd,
  eventStart,
  networkBytes,
  networkCommunityId,
  networkDirection,
  networkPackets,
  networkProtocol,
  processName,
  sourceBytes,
  sourceGeoContinentName,
  sourceGeoCountryName,
  sourceGeoCountryIsoCode,
  sourceGeoRegionName,
  sourceGeoCityName,
  sourceIp,
  sourcePackets,
  sourcePort,
  transport,
  userName
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  "data-test-subj": "netflow-columns",
  gutterSize: "none",
  justifyContent: "center",
  wrap: true
}, /*#__PURE__*/_react.default.createElement(EuiFlexItemMarginRight, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_user_process.UserProcess, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: eventId,
  processName: processName,
  userName: userName
})), /*#__PURE__*/_react.default.createElement(EuiFlexItemMarginRight, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_duration_event_start_end.DurationEventStartEnd, {
  scopeId: scopeId,
  contextId: contextId,
  eventDuration: eventDuration,
  eventId: eventId,
  eventEnd: eventEnd,
  eventStart: eventStart
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_source_destination.SourceDestination, {
  scopeId: scopeId,
  contextId: contextId,
  destinationBytes: destinationBytes,
  destinationGeoContinentName: destinationGeoContinentName,
  destinationGeoCountryName: destinationGeoCountryName,
  destinationGeoCountryIsoCode: destinationGeoCountryIsoCode,
  destinationGeoRegionName: destinationGeoRegionName,
  destinationGeoCityName: destinationGeoCityName,
  destinationIp: destinationIp,
  destinationPackets: destinationPackets,
  destinationPort: destinationPort,
  eventId: eventId,
  networkBytes: networkBytes,
  networkCommunityId: networkCommunityId,
  networkDirection: networkDirection,
  networkPackets: networkPackets,
  networkProtocol: networkProtocol,
  sourceBytes: sourceBytes,
  sourceGeoContinentName: sourceGeoContinentName,
  sourceGeoCountryName: sourceGeoCountryName,
  sourceGeoCountryIsoCode: sourceGeoCountryIsoCode,
  sourceGeoRegionName: sourceGeoRegionName,
  sourceGeoCityName: sourceGeoCityName,
  sourceIp: sourceIp,
  sourcePackets: sourcePackets,
  sourcePort: sourcePort,
  transport: transport
}))));
NetflowColumns.displayName = 'NetflowColumns';