"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineModalHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _common = require("@kbn/data-plugin/common");
var _common2 = require("@kbn/kibana-react-plugin/common");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _containers = require("../../../../sourcerer/containers");
var _model = require("../../../../sourcerer/store/model");
var _new_timeline_button = require("../actions/new_timeline_button");
var _open_timeline_button = require("../actions/open_timeline_button");
var _common3 = require("../../../../../common");
var _selectors = require("../../../store/selectors");
var _helpers = require("../../../../common/utils/global_query_string/helpers");
var _store = require("../../../store");
var _kibana = require("../../../../common/lib/kibana");
var _kuery = require("../../../../common/lib/kuery");
var i18n = _interopRequireWildcard(require("../translations"));
var _add_to_favorites = require("../../add_to_favorites");
var _save_status = require("../../save_status");
var _inspect = require("../../../../common/components/inspect");
var _constants = require("../../../../common/store/inputs/constants");
var _attach_to_case_button = require("../actions/attach_to_case_button");
var _save_timeline_button = require("../actions/save_timeline_button");
var _use_browser_fields = require("../../../../data_view_manager/hooks/use_browser_fields");
var _constants2 = require("../../../../data_view_manager/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const whiteSpaceNoWrapCSS = {
  'white-space': 'nowrap'
};
const autoOverflowXCSS = {
  'overflow-x': 'auto'
};
const VerticalDivider = _styledComponents.default.span`
  width: 0;
  height: 20px;
  border-left: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
`;
const TimelinePanel = (0, _common2.euiStyled)(_eui.EuiPanel)`
  backgroundColor: ${props => props.theme.eui.euiColorEmptyShade};
  color: ${props => props.theme.eui.euiTextColor};
  padding-inline: ${props => props.theme.eui.euiSizeM};
  border-radius: ${({
  theme
}) => theme.eui.euiBorderRadius};
`;
/**
 * Component rendered at the top of the timeline modal. It contains the timeline title, all the action buttons (save, open, favorite...) and the close button
 */
const TimelineModalHeader = exports.TimelineModalHeader = /*#__PURE__*/_react.default.memo(({
  timelineId,
  openToggleRef
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    browserFields: sourcererBrowserFields,
    sourcererDataView: oldSourcererDataViewSpec
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_constants2.DataViewManagerScopeName.timeline);
  const experimentalBrowserFields = (0, _use_browser_fields.useBrowserFields)(_constants2.DataViewManagerScopeName.timeline);
  const browserFields = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalBrowserFields : sourcererBrowserFields, [experimentalBrowserFields, newDataViewPickerEnabled, sourcererBrowserFields]);
  const {
    cases,
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const esQueryConfig = (0, _react.useMemo)(() => (0, _common.getEsQueryConfig)(uiSettings), [uiSettings]);
  const userCasesPermissions = (0, _react.useMemo)(() => cases.helpers.canUseCases([_common3.APP_ID]), [cases]);
  const title = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTitleByTimelineById)(state, timelineId));
  const isDataInTimeline = (0, _reactRedux.useSelector)(state => (0, _selectors.selectDataInTimeline)(state, timelineId));
  const kqlQueryObj = (0, _reactRedux.useSelector)(state => (0, _selectors.selectKqlQuery)(state, timelineId));
  const {
    activeTab,
    dataProviders,
    timelineType,
    filters,
    kqlMode
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTimelineById)(state, timelineId));
  const combinedQueries = (0, _react.useMemo)(() => (0, _kuery.combineQueries)({
    config: esQueryConfig,
    dataProviders,
    dataViewSpec: oldSourcererDataViewSpec,
    dataView: experimentalDataView,
    browserFields,
    filters: filters ? filters : [],
    kqlQuery: kqlQueryObj,
    kqlMode
  }), [browserFields, dataProviders, esQueryConfig, experimentalDataView, filters, kqlMode, kqlQueryObj, oldSourcererDataViewSpec]);
  const isInspectDisabled = !isDataInTimeline || (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) === undefined;
  const closeTimeline = (0, _react.useCallback)(() => {
    if (openToggleRef.current != null) {
      openToggleRef.current.focus();
    }
    (0, _helpers.createHistoryEntry)();
    dispatch(_store.timelineActions.showTimeline({
      id: timelineId,
      show: false
    }));
  }, [dispatch, timelineId, openToggleRef]);
  return /*#__PURE__*/_react.default.createElement(TimelinePanel, {
    grow: false,
    paddingSize: "s",
    hasShadow: false,
    "data-test-subj": "timeline-modal-header-panel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "eui-scrollBar",
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    justifyContent: "spaceBetween",
    css: autoOverflowXCSS
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_to_favorites.AddToFavoritesButton, {
    timelineId: timelineId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    grow: false,
    "data-test-subj": "timeline-modal-header-title",
    css: whiteSpaceNoWrapCSS
  }, /*#__PURE__*/_react.default.createElement("h3", null, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_save_status.TimelineSaveStatus, {
    timelineId: timelineId
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "xs",
    responsive: false,
    "data-test-subj": "timeline-modal-header-actions"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_new_timeline_button.NewTimelineButton, {
    timelineId: timelineId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_open_timeline_button.OpenTimelineButton, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: `${timelineId}-${activeTab}`,
    inputId: _constants.InputsModelId.timeline,
    isDisabled: isInspectDisabled
  })), userCasesPermissions.createComment && userCasesPermissions.read ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(VerticalDivider, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_attach_to_case_button.AttachToCaseButton, {
    timelineId: timelineId
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_save_timeline_button.SaveTimelineButton, {
    timelineId: timelineId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.CLOSE_TIMELINE_OR_TEMPLATE(timelineType === 'default')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.CLOSE_TIMELINE_OR_TEMPLATE(timelineType === 'default'),
    iconType: "cross",
    "data-test-subj": "timeline-modal-header-close-button",
    onClick: closeTimeline
  })))))));
});
TimelineModalHeader.displayName = 'TimelineModalHeader';