"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormattedDuration = void 0;
var _react = _interopRequireDefault(require("react"));
var _helpers = require("./helpers");
var _tooltip = require("./tooltip");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormattedDuration = exports.FormattedDuration = /*#__PURE__*/_react.default.memo(({
  maybeDurationNanoseconds,
  tooltipTitle
}) => /*#__PURE__*/_react.default.createElement(_tooltip.FormattedDurationTooltip, {
  maybeDurationNanoseconds: maybeDurationNanoseconds,
  tooltipTitle: tooltipTitle
}, /*#__PURE__*/_react.default.createElement("div", {
  "data-test-subj": "formatted-duration"
}, (0, _helpers.getFormattedDurationString)(maybeDurationNanoseconds))));
FormattedDuration.displayName = 'FormattedDuration';