"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetScopedSourcererDataView = void 0;
var _react = require("react");
var _public = require("@kbn/data-views-plugin/public");
var _containers = require("../containers");
var _kibana = require("../../common/lib/kibana");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 *
 * returns the created dataView based on sourcererDataView spec
 * returned from useSourcererDataView
 *
 * */
const useGetScopedSourcererDataView = ({
  sourcererScope
}) => {
  const {
    services: {
      fieldFormats
    }
  } = (0, _kibana.useKibana)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    sourcererDataView
  } = (0, _containers.useSourcererDataView)(sourcererScope);
  const dataView = (0, _react.useMemo)(() => {
    if (!newDataViewPickerEnabled && Object.keys(sourcererDataView).length) {
      return new _public.DataView({
        spec: sourcererDataView,
        fieldFormats
      });
    } else {
      return undefined;
    }
  }, [newDataViewPickerEnabled, sourcererDataView, fieldFormats]);
  return dataView;
};
exports.useGetScopedSourcererDataView = useGetScopedSourcererDataView;