"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResultVisColors = exports.convertTranslationResultIntoText = exports.convertTranslationResultIntoColor = void 0;
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/siem_migrations/constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COLORS = {
  [_constants.RuleTranslationResult.FULL]: '#54B399',
  [_constants.RuleTranslationResult.PARTIAL]: '#D6BF57',
  [_constants.RuleTranslationResult.UNTRANSLATABLE]: '#DA8B45',
  error: '#E7664C'
};
const useResultVisColors = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (euiTheme.themeName === 'EUI_THEME_AMSTERDAM') {
    return {
      [_constants.RuleTranslationResult.FULL]: euiTheme.colors.vis.euiColorVis0,
      [_constants.RuleTranslationResult.PARTIAL]: euiTheme.colors.vis.euiColorVis5,
      [_constants.RuleTranslationResult.UNTRANSLATABLE]: euiTheme.colors.vis.euiColorVis7,
      error: euiTheme.colors.vis.euiColorVis9
    };
  }
  // Borealis
  return COLORS;
};
exports.useResultVisColors = useResultVisColors;
const convertTranslationResultIntoColor = status => {
  switch (status) {
    case _constants.RuleTranslationResult.FULL:
      return COLORS[_constants.RuleTranslationResult.FULL];
    case _constants.RuleTranslationResult.PARTIAL:
      return COLORS[_constants.RuleTranslationResult.PARTIAL];
    case _constants.RuleTranslationResult.UNTRANSLATABLE:
      return COLORS[_constants.RuleTranslationResult.UNTRANSLATABLE];
    default:
      return 'subdued';
  }
};
exports.convertTranslationResultIntoColor = convertTranslationResultIntoColor;
const convertTranslationResultIntoText = status => {
  switch (status) {
    case _constants.RuleTranslationResult.FULL:
      return i18n.SIEM_TRANSLATION_RESULT_FULL_LABEL;
    case _constants.RuleTranslationResult.PARTIAL:
      return i18n.SIEM_TRANSLATION_RESULT_PARTIAL_LABEL;
    case _constants.RuleTranslationResult.UNTRANSLATABLE:
      return i18n.SIEM_TRANSLATION_RESULT_UNTRANSLATABLE_LABEL;
    default:
      return i18n.SIEM_TRANSLATION_RESULT_UNKNOWN_LABEL;
  }
};
exports.convertTranslationResultIntoText = convertTranslationResultIntoText;