"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteMigration = exports.DELETE_MIGRATION_RULE_MUTATION_KEY = void 0;
var _reactQuery = require("@kbn/react-query");
var _kibana_react = require("../../../common/lib/kibana/kibana_react");
var _constants = require("../../../../common/siem_migrations/constants");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DELETE_MIGRATION_RULE_MUTATION_KEY = exports.DELETE_MIGRATION_RULE_MUTATION_KEY = ['DELETE', _constants.SIEM_RULE_MIGRATION_PATH];
const useDeleteMigration = migrationId => {
  const {
    addError,
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const rulesMigrationService = (0, _kibana_react.useKibana)().services.siemMigrations.rules;
  return (0, _reactQuery.useMutation)({
    mutationFn: () => rulesMigrationService.deleteMigration(migrationId),
    mutationKey: DELETE_MIGRATION_RULE_MUTATION_KEY,
    onSuccess: () => {
      addSuccess(i18n.DELETE_MIGRATION_SUCCESS);
    },
    onError: error => {
      addError(error, {
        title: i18n.DELETE_MIGRATION_FAILURE
      });
    }
  });
};
exports.useDeleteMigration = useDeleteMigration;