"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TableHeader = exports.TableHeader = /*#__PURE__*/_react.default.memo(({
  id,
  title,
  tooltipContent
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: tooltipContent
  }, /*#__PURE__*/_react.default.createElement("div", {
    id: id
  }, title, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: "question",
    color: "subdued",
    className: "eui-alignTop"
  })));
});
TableHeader.displayName = 'TableHeader';