"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REPROCESS_FAILED_RULES = exports.REPROCESS_FAILED_ARIA_LABEL = exports.INSTALL_TRANSLATED_RULES_EMPTY_STATE = exports.INSTALL_TRANSLATED_RULES = exports.INSTALL_TRANSLATED_ARIA_LABEL = exports.INSTALL_SELECTED_RULES = exports.INSTALL_SELECTED_ARIA_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INSTALL_SELECTED_RULES = numberOfSelectedRules => {
  return _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.table.installSelectedRules', {
    defaultMessage: 'Install selected ({numberOfSelectedRules})',
    values: {
      numberOfSelectedRules
    }
  });
};
exports.INSTALL_SELECTED_RULES = INSTALL_SELECTED_RULES;
const REPROCESS_FAILED_RULES = numberOfFailedRules => {
  return _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.table.reprocessFailedRules', {
    defaultMessage: 'Reprocess rules ({numberOfFailedRules})',
    values: {
      numberOfFailedRules
    }
  });
};
exports.REPROCESS_FAILED_RULES = REPROCESS_FAILED_RULES;
const INSTALL_SELECTED_ARIA_LABEL = exports.INSTALL_SELECTED_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.table.installSelectedButtonAriaLabel', {
  defaultMessage: 'Install selected translated rules'
});
const INSTALL_TRANSLATED_ARIA_LABEL = exports.INSTALL_TRANSLATED_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.table.installTranslatedButtonAriaLabel', {
  defaultMessage: 'Install all translated rules'
});
const INSTALL_TRANSLATED_RULES = numberOfAllRules => {
  return _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.table.installTranslatedRules', {
    defaultMessage: 'Install translated {numberOfAllRules, plural, one {rule} other {rules}} ({numberOfAllRules})',
    values: {
      numberOfAllRules
    }
  });
};
exports.INSTALL_TRANSLATED_RULES = INSTALL_TRANSLATED_RULES;
const INSTALL_TRANSLATED_RULES_EMPTY_STATE = exports.INSTALL_TRANSLATED_RULES_EMPTY_STATE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.table.installTranslatedRulesEmptyState', {
  defaultMessage: 'Install translated rules'
});
const REPROCESS_FAILED_ARIA_LABEL = exports.REPROCESS_FAILED_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.table.reprocessFailedRulesButtonAriaLabel', {
  defaultMessage: 'Reprocess failed rules'
});