"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryViewer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QueryViewer = exports.QueryViewer = /*#__PURE__*/_react.default.memo(({
  ruleName,
  language,
  query,
  queryPlaceholder,
  onEdit
}) => {
  const codeBlockLanguage = (0, _react.useMemo)(() => {
    if (language === 'spl') {
      return 'splunk-spl';
    }
    return 'sql';
  }, [language]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, onEdit ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "editTranslatedRuleBtn",
    iconType: "pencil",
    onClick: onEdit,
    size: "xs"
  }, i18n.EDIT))) : /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, ruleName)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), query.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "data-test-subj": "translatedRuleQueryViewer",
    language: codeBlockLanguage,
    fontSize: "s",
    paddingSize: "s",
    className: "eui-textBreakWord"
  }, query) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, queryPlaceholder));
});
QueryViewer.displayName = 'QueryViewer';