"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var selectors = _interopRequireWildcard(require("../../store/selectors"));
var _node_events_of_type = require("./node_events_of_type");
var _node_events = require("./node_events");
var _node_detail = require("./node_detail");
var _node_list = require("./node_list");
var _event_detail = require("./event_detail");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Show the panel that matches the `panelViewAndParameters` (derived from the browser's location.search)
 */

// eslint-disable-next-line react/display-name
const PanelRouter = exports.PanelRouter = /*#__PURE__*/(0, _react.memo)(function ({
  id,
  nodeEventOnClick
}) {
  const params = (0, _reactRedux.useSelector)(state => selectors.panelViewAndParameters(state.analyzer[id]));
  if (params.panelView === 'nodeDetail') {
    return /*#__PURE__*/_react.default.createElement(_node_detail.NodeDetail, {
      id: id,
      nodeID: params.panelParameters.nodeID,
      nodeEventOnClick: nodeEventOnClick
    });
  } else if (params.panelView === 'nodeEvents') {
    return /*#__PURE__*/_react.default.createElement(_node_events.NodeEvents, {
      id: id,
      nodeID: params.panelParameters.nodeID
    });
  } else if (params.panelView === 'nodeEventsInCategory') {
    return /*#__PURE__*/_react.default.createElement(_node_events_of_type.NodeEventsInCategory, {
      id: id,
      nodeID: params.panelParameters.nodeID,
      eventCategory: params.panelParameters.eventCategory,
      nodeEventOnClick: nodeEventOnClick
    });
  } else if (params.panelView === 'eventDetail') {
    return /*#__PURE__*/_react.default.createElement(_event_detail.EventDetail, {
      id: id,
      nodeID: params.panelParameters.nodeID,
      eventCategory: params.panelParameters.eventCategory
    });
  } else {
    /* The default 'Event List' / 'List of all processes' view */
    return /*#__PURE__*/_react.default.createElement(_node_list.NodeList, {
      id: id
    });
  }
});