"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERSION = exports.REGION = exports.PLATFORM = exports.OS = exports.MAX_ANOMALY_SCORE_BY_JOB = exports.MAC_ADDRESSES = exports.MACHINE_TYPE = exports.LAST_SEEN = exports.IP_ADDRESSES = exports.INSTANCE_ID = exports.INSPECT_TITLE = exports.HOST_RISK_SCORE = exports.HOST_RISK_LEVEL = exports.HOST_ID = exports.FIRST_SEEN = exports.FAMILY = exports.CLOUD_PROVIDER = exports.ARCHITECTURE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOST_ID = exports.HOST_ID = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.hostIdTitle', {
  defaultMessage: 'Host ID'
});
const FIRST_SEEN = exports.FIRST_SEEN = _i18n.i18n.translate('xpack.securitySolution.host.details.firstSeenTitle', {
  defaultMessage: 'First seen'
});
const LAST_SEEN = exports.LAST_SEEN = _i18n.i18n.translate('xpack.securitySolution.host.details.lastSeenTitle', {
  defaultMessage: 'Last seen'
});
const MAX_ANOMALY_SCORE_BY_JOB = exports.MAX_ANOMALY_SCORE_BY_JOB = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.maxAnomalyScoreByJobTitle', {
  defaultMessage: 'Max anomaly score by job'
});
const HOST_RISK_SCORE = exports.HOST_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.hostRiskScoreTitle', {
  defaultMessage: 'Host risk score'
});
const HOST_RISK_LEVEL = exports.HOST_RISK_LEVEL = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.hostRiskLevel', {
  defaultMessage: 'Host risk level'
});
const IP_ADDRESSES = exports.IP_ADDRESSES = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.ipAddressesTitle', {
  defaultMessage: 'IP addresses'
});
const MAC_ADDRESSES = exports.MAC_ADDRESSES = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.macAddressesTitle', {
  defaultMessage: 'MAC addresses'
});
const PLATFORM = exports.PLATFORM = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.platformTitle', {
  defaultMessage: 'Platform'
});
const OS = exports.OS = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.osTitle', {
  defaultMessage: 'Operating system'
});
const FAMILY = exports.FAMILY = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.familyTitle', {
  defaultMessage: 'Family'
});
const VERSION = exports.VERSION = _i18n.i18n.translate('xpack.securitySolution.host.details.versionLabel', {
  defaultMessage: 'Version'
});
const ARCHITECTURE = exports.ARCHITECTURE = _i18n.i18n.translate('xpack.securitySolution.host.details.architectureLabel', {
  defaultMessage: 'Architecture'
});
const CLOUD_PROVIDER = exports.CLOUD_PROVIDER = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.cloudProviderTitle', {
  defaultMessage: 'Cloud provider'
});
const REGION = exports.REGION = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.regionTitle', {
  defaultMessage: 'Region'
});
const INSTANCE_ID = exports.INSTANCE_ID = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.instanceIdTitle', {
  defaultMessage: 'Instance ID'
});
const MACHINE_TYPE = exports.MACHINE_TYPE = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.machineTypeTitle', {
  defaultMessage: 'Machine type'
});
const INSPECT_TITLE = exports.INSPECT_TITLE = _i18n.i18n.translate('xpack.securitySolution.host.details.overview.inspectTitle', {
  defaultMessage: 'Host overview'
});