"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCasesByStatus = void 0;
var _common = require("@kbn/cases-plugin/common");
var _react = require("react");
var _uuid = require("uuid");
var _constants = require("../../../../../common/constants");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _kibana = require("../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCasesByStatus = ({
  skip = false
}) => {
  var _casesCounts$closed, _casesCounts$inProgre, _casesCounts$open, _casesCounts$closed2, _casesCounts$inProgre2, _casesCounts$open2;
  const {
    services: {
      cases
    }
  } = (0, _kibana.useKibana)();
  const {
    to,
    from,
    setQuery,
    deleteQuery
  } = (0, _use_global_time.useGlobalTime)();
  // create a unique, but stable (across re-renders) query id
  const uniqueQueryId = (0, _react.useMemo)(() => `useCaseItems-${(0, _uuid.v4)()}`, []);
  const [updatedAt, setUpdatedAt] = (0, _react.useState)(Date.now());
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [casesCounts, setCasesCounts] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    const abortCtrl = new AbortController();
    const fetchCases = async () => {
      try {
        const casesResponse = await cases.api.cases.getCasesMetrics({
          features: [_common.CaseMetricsFeature.STATUS],
          from,
          to,
          owner: _constants.APP_ID
        }, abortCtrl.signal);
        if (isSubscribed) {
          setCasesCounts(casesResponse.status);
        }
      } catch (error) {
        if (isSubscribed) {
          setCasesCounts(null);
        }
      }
      if (isSubscribed) {
        setIsLoading(false);
        setUpdatedAt(Date.now());
      }
    };
    if (!skip) {
      fetchCases();
      setQuery({
        id: uniqueQueryId,
        inspect: null,
        loading: false,
        refetch: fetchCases
      });
    }
    if (skip) {
      setIsLoading(false);
      isSubscribed = false;
      abortCtrl.abort();
    }
    return () => {
      isSubscribed = false;
      abortCtrl.abort();
      deleteQuery({
        id: uniqueQueryId
      });
    };
  }, [cases.api.cases, from, skip, to, setQuery, deleteQuery, uniqueQueryId]);
  return {
    closed: (_casesCounts$closed = casesCounts === null || casesCounts === void 0 ? void 0 : casesCounts.closed) !== null && _casesCounts$closed !== void 0 ? _casesCounts$closed : 0,
    inProgress: (_casesCounts$inProgre = casesCounts === null || casesCounts === void 0 ? void 0 : casesCounts.inProgress) !== null && _casesCounts$inProgre !== void 0 ? _casesCounts$inProgre : 0,
    isLoading,
    open: (_casesCounts$open = casesCounts === null || casesCounts === void 0 ? void 0 : casesCounts.open) !== null && _casesCounts$open !== void 0 ? _casesCounts$open : 0,
    totalCounts: ((_casesCounts$closed2 = casesCounts === null || casesCounts === void 0 ? void 0 : casesCounts.closed) !== null && _casesCounts$closed2 !== void 0 ? _casesCounts$closed2 : 0) + ((_casesCounts$inProgre2 = casesCounts === null || casesCounts === void 0 ? void 0 : casesCounts.inProgress) !== null && _casesCounts$inProgre2 !== void 0 ? _casesCounts$inProgre2 : 0) + ((_casesCounts$open2 = casesCounts === null || casesCounts === void 0 ? void 0 : casesCounts.open) !== null && _casesCounts$open2 !== void 0 ? _casesCounts$open2 : 0),
    updatedAt
  };
};
exports.useCasesByStatus = useCasesByStatus;