"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCardStyles = void 0;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCardStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  return (0, _css.css)`
    min-width: 315px;
    /* We needed to add the "headerCard" class to make it take priority over the default EUI card styles */
    &.headerCard:hover {
      *:not(.headerCardLink) {
        text-decoration: none;
      }
      .headerCardLink,
      .headerCardLink * {
        text-decoration: underline;
        text-decoration-color: ${euiTheme.colors.textPrimary};
      }
    }

    .headerCardTitle {
      font-weight: ${euiTheme.font.weight.semiBold};
    }

    ${isDarkMode ? `
          background-color: ${euiTheme.colors.backgroundBasePlain};
          box-shadow: none;
          border: ${euiTheme.border.width.thin} solid ${euiTheme.colors.borderBasePlain};
        ` : ''}
  `;
};
exports.useCardStyles = useCardStyles;