"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardSelectorList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _card_selector_list = require("./card_selector_list.styles");
var _onboarding_card_panel = require("../../onboarding_card_panel.styles");
var _onboarding_context = require("../../../onboarding_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scrollToSelectedItem = cardId => {
  setTimeout(() => {
    const element = document.getElementById(`selector-${cardId}`);
    if (element) {
      element.scrollIntoView({
        behavior: 'smooth',
        block: 'nearest'
      });
    }
  }, _onboarding_card_panel.HEIGHT_ANIMATION_DURATION + 250);
};
const CardSelectorList = exports.CardSelectorList = /*#__PURE__*/_react.default.memo(({
  items,
  onSelect,
  selectedItem,
  title,
  cardId
}) => {
  const {
    telemetry
  } = (0, _onboarding_context.useOnboardingContext)();
  const styles = (0, _card_selector_list.useCardSelectorListStyles)();
  (0, _react.useEffect)(() => {
    scrollToSelectedItem(selectedItem.id);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const handleSelect = (0, _react.useCallback)(item => {
    onSelect(item);
    telemetry.reportCardSelectorClicked(cardId, item.id);
  }, [cardId, onSelect, telemetry]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "cardSelectorList",
    direction: "column",
    gutterSize: "s",
    className: styles
  }, title && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    className: "cardSelectorTitle"
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    id: "scroll-container",
    className: "cardSelectorContent",
    direction: "column",
    gutterSize: "s"
  }, items.map(item => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `key-${item.id}`,
    id: `selector-${item.id}`,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": `cardSelectorItem-${item.id}`,
    className: selectedItem.id === item.id ? 'selectedCardPanelItem' : '',
    color: selectedItem.id === item.id ? 'subdued' : 'plain',
    element: "button",
    onClick: () => handleSelect(item)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, item.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, item.description)))))));
});
CardSelectorList.displayName = 'CardSelectorList';