"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingCardContentAssetPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _card_content_panel = require("./card_content_panel");
var _card_content_asset_panel = require("./card_content_asset_panel.styles");
var _types = require("../types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OnboardingCardContentAssetPanel = exports.OnboardingCardContentAssetPanel = /*#__PURE__*/_react.default.memo(({
  children,
  asset: {
    type,
    source,
    alt
  }
}) => {
  const styles = (0, _card_content_asset_panel.useCardContentAssetPanelStyles)();
  const renderAssetContent = (0, _react.useMemo)(() => {
    if (type === _types.CardAssetType.video) return /*#__PURE__*/_react.default.createElement("iframe", {
      allowFullScreen: true,
      height: "275px",
      width: "488px",
      allow: "autoplay",
      referrerPolicy: "no-referrer",
      sandbox: "allow-scripts allow-same-origin",
      src: source,
      title: 'title'
    });
    return /*#__PURE__*/_react.default.createElement("img", {
      src: source,
      alt: alt
    });
  }, [alt, source, type]);
  return /*#__PURE__*/_react.default.createElement(_card_content_panel.OnboardingCardContentPanel, {
    className: styles
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "cardSpacer",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "cardImage",
    grow: false
  }, renderAssetContent)));
});
OnboardingCardContentAssetPanel.displayName = 'OnboardingCardContentAssetPanel';